/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskApplicationSettings;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskContentPane;
import filenet.vw.apps.taskman.VWTaskMenuBar;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskRootNode;
import filenet.vw.apps.taskman.VWTaskScopePane;
import filenet.vw.apps.taskman.VWTaskToolBar;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.message.VWConsoleEvent;
import filenet.vw.apps.taskman.message.VWConsoleListener;
import filenet.vw.apps.taskman.message.VWConsoleMsgPanel;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Level;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWAboutHelper;
import filenet.vw.toolkit.utils.VWBaseCore;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import org.w3c.dom.Element;

public class VWTaskCore
extends VWBaseCore
implements ActionListener,
TreeModelListener {
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private static VWTaskCore m_instance = null;
    public static boolean m_bAutoMode = false;
    private boolean m_initialized = false;
    private VWTaskToolBar m_toolBar = null;
    private VWTaskMenuBar m_menuBar = null;
    private VWConsoleMsgPanel m_consoleMsgPanel = null;
    private EventListenerList m_consoleListenerList = new EventListenerList();
    private JFrame m_mainFrame = null;
    private ActionEvent m_actionEvent = null;
    private boolean m_appInputEnabled = true;
    private VWTaskApplicationSettings m_appSettings = null;
    private JPanel m_mainPanel = null;
    private VWSplitPane m_rootSplitPane = null;
    private VWSplitPane m_viewSplitPane = null;
    private boolean m_bViewMsgPane = true;
    private DefaultTreeModel m_treeModel = null;
    private VWTaskRootNode m_taskRoot = null;
    private VWTaskScopePane m_vwScopePane = null;
    private VWTaskContentPane m_vwContentPane = null;
    private EventListenerList m_listenerList = new EventListenerList();
    private String m_ports = null;
    public static final int DEFAULT_RMI_PORT = 32771;

    public static VWTaskCore getInstance() {
        if (m_instance == null) {
            m_instance = new VWTaskCore();
        }
        return m_instance;
    }

    public JFrame getMainFrame() {
        if (this.isAutoMode() && this.m_mainFrame == null) {
            this.m_mainFrame = new JFrame();
        }
        return this.m_mainFrame;
    }

    public String getApplicationTitle() {
        return this.m_mainFrame.getTitle();
    }

    public boolean isAutoMode() {
        return m_bAutoMode;
    }

    public VWTaskXMLHandler getXMLHandler(String propertyFilePath) {
        return this.m_appSettings.getXMLHandler(propertyFilePath);
    }

    public void displayError(Throwable t) {
        this.displayError(t, true);
    }

    public void displayError(Throwable t, VWTaskBaseNode node) {
        this.displayError(t, true, node);
    }

    public void displayError(Throwable t, boolean displayInMsgPanel) {
        this.displayError(t, displayInMsgPanel, this.getSelectedNode());
    }

    public void displayError(Throwable t, boolean displayInMsgPanel, VWTaskBaseNode node) {
        if (this.isAutoMode()) {
            throw new RuntimeException(VWTaskUtil.getStackTrace(t));
        }
        String message = t.getLocalizedMessage();
        String stackTrace = VWTaskUtil.getStackTrace(t);
        if (displayInMsgPanel && node != null) {
            node.writeMessage(Level.SEVERE, stackTrace);
        }
        VWMessageDialog.showOptionDialog((Frame)this.m_mainFrame, message != null ? message : stackTrace, 1);
    }

    public void displayError(String message) {
        this.displayError(message, true);
    }

    public void displayError(String message, VWTaskBaseNode node) {
        this.displayError(message, true, node);
    }

    public void displayError(String message, boolean displayInMsgPanel) {
        this.displayError(message, displayInMsgPanel, this.getSelectedNode());
    }

    public void displayError(String message, boolean displayInMsgPanel, VWTaskBaseNode node) {
        if (this.isAutoMode()) {
            throw new RuntimeException(message);
        }
        if (displayInMsgPanel && node != null) {
            node.writeMessage(Level.SEVERE, message);
        }
        VWMessageDialog.showOptionDialog((Frame)this.m_mainFrame, message, 1);
    }

    public void displayWarning(String message) {
        this.displayWarning(message, this.getSelectedNode());
    }

    public void displayWarning(String message, VWTaskBaseNode node) {
        this.displayWarning(message, true, this.getSelectedNode());
    }

    public void displayWarning(String message, boolean displayInMsgPanel, VWTaskBaseNode node) {
        if (!this.isAutoMode()) {
            if (displayInMsgPanel && node != null) {
                node.writeMessage(Level.WARNING, message);
            }
            VWMessageDialog.showOptionDialog((Frame)this.m_mainFrame, message, 3);
        }
    }

    public void displayWarning(Throwable t) {
        this.displayWarning(t, this.getSelectedNode());
    }

    public void displayWarning(Throwable t, VWTaskBaseNode node) {
        this.displayWarning(t, true, node);
    }

    public void displayWarning(Throwable t, boolean displayInMsgPanel, VWTaskBaseNode node) {
        if (this.isAutoMode()) {
            throw new RuntimeException(VWTaskUtil.getStackTrace(t));
        }
        String message = t.getLocalizedMessage();
        String stackTrace = VWTaskUtil.getStackTrace(t);
        if (displayInMsgPanel && node != null) {
            node.writeMessage(Level.WARNING, stackTrace);
        }
        VWMessageDialog.showOptionDialog((Frame)this.m_mainFrame, message != null ? message : stackTrace, 3);
    }

    public void displayInformation(String message) {
        if (!this.isAutoMode()) {
            VWMessageDialog.showOptionDialog((Frame)this.m_mainFrame, message, 2);
        }
    }

    public void displayInformation(String message, String title) {
        if (!this.isAutoMode()) {
            VWMessageDialog.showOptionDialog((Frame)this.m_mainFrame, message, title, 2);
        }
    }

    public boolean displayConfirmation(String message, int msgType, String helpLink, int width, int height) {
        if (!this.isAutoMode()) {
            int dlgResult;
            int buttons = 3;
            if (helpLink != null) {
                buttons |= 0x20;
            }
            return (dlgResult = VWMessageDialog.showOptionDialog((Frame)this.getMainFrame(), message, VWResource.Confirmation, msgType, buttons, helpLink, null, width, height)) == 1;
        }
        return true;
    }

    public boolean displayConfirmation(String message, int msgType, String helpLink) {
        return this.displayConfirmation(message, msgType, helpLink, 0, 0);
    }

    public boolean displayConfirmation(String message, int msgType) {
        return this.displayConfirmation(message, msgType, null);
    }

    public boolean displayConfirmation(String message) {
        return this.displayConfirmation(message, 4);
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "_start_here_taskmanager.htm");
    }

    public void displayAbout() {
        try {
            VWIDMBaseFactory.instance("WORKPLACE");
            String productName = VWIDMBaseFactory.instance().getVWString(11).toString();
            VWAboutHelper aboutBox = new VWAboutHelper((Frame)this.m_mainFrame, productName, null, this.m_vwSessionInfo);
            aboutBox.display();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isServiceMode() {
        return VWTaskCore.isWindowsOS() && VWTaskApplicationSettings.getInstance().getProperties().getBoolean("TaskManager.ServiceMode");
    }

    public static boolean isWindowsOS() {
        return VWTaskUtil.getOSType() == VWTaskUtil.OS_TYPE_WINDOWS;
    }

    public void expandNode(final VWTaskBaseNode node, final boolean setFocus) {
        if (this.isAutoMode()) {
            return;
        }
        if (this.m_vwScopePane == null) {
            throw new IllegalStateException("VWTaskCore::expandNode - Attempt to call expand node and scope pane not initialized yet.");
        }
        Runnable operation = new Runnable(){

            public void run() {
                VWTaskCore.this.m_vwScopePane.expandScopeTree(node, setFocus);
            }
        };
        VWTaskUtil.performUIOperation(operation);
    }

    public void setFocus(final VWTaskBaseNode node) {
        if (this.isAutoMode()) {
            return;
        }
        Runnable operation = new Runnable(){

            public void run() {
                VWTaskCore.this.m_vwScopePane.setFocus(node);
            }
        };
        VWTaskUtil.performUIOperation(operation, true);
    }

    public synchronized void updateApplicationFile() {
        if (!this.isAutoMode()) {
            try {
                VWDebug.logInfo("Updating application settings file.");
                String ATTRIB_INDENT = "\t";
                StringBuffer xmlHeader = new StringBuffer();
                xmlHeader.append("<?xml version='1.0' encoding='UTF-8'?>\n");
                xmlHeader.append("<!DOCTYPE TaskManagerDefinition>\n");
                xmlHeader.append("<TaskManagerDefinition\n");
                xmlHeader.append(ATTRIB_INDENT + "ShowMessages=\"" + VWTaskXMLHandler.booleanToString(this.m_bViewMsgPane) + "\"\n");
                xmlHeader.append(ATTRIB_INDENT + "MessageLevel=\"" + this.m_consoleMsgPanel.getMessageLevel().toString() + "\"\n");
                xmlHeader.append(ATTRIB_INDENT + "MaxMessages=\"" + this.m_consoleMsgPanel.getMaxMessages() + "\">\n");
                String xmlFooter = "</TaskManagerDefinition>\n";
                HashMap xmlMap = this.m_taskRoot.toXML(xmlHeader, xmlFooter);
                this.m_appSettings.updateApplicationSettings(xmlMap);
            }
            catch (Exception e) {
                VWDebug.logException(e, "Error saving application settings: " + e.getLocalizedMessage());
            }
        }
    }

    public void addVWConsoleListener(VWConsoleListener listener) {
        if (this.isAutoMode()) {
            return;
        }
        this.m_consoleListenerList.add(VWConsoleListener.class, listener);
    }

    public void removeVWConsoleListener(VWConsoleListener listener) {
        if (this.isAutoMode()) {
            return;
        }
        this.m_consoleListenerList.remove(VWConsoleListener.class, listener);
    }

    public void actionPerformed(ActionEvent event) {
        this.m_actionEvent = event;
        String actionCMD = this.m_actionEvent.getActionCommand();
        final VWTaskBaseNode selectedNode = this.getSelectedNode();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.UP) == 0) {
                this.m_vwScopePane.moveFocusUp();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP_TOPICS) == 0) {
                VWTaskCore.getInstance().displayHelp();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH) == 0) {
                Runnable actionPerformer = new Runnable(){

                    public void run() {
                        VWTaskCore.this.disableApplicationInput();
                        try {
                            VWTaskCore.this.m_taskRoot.refresh();
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                        }
                        selectedNode.nodeChanged();
                        VWTaskCore.this.enableApplicationInput();
                    }
                };
                new Thread(actionPerformer).start();
            } else if (VWStringUtils.compare(actionCMD, "Look and Feel") == 0) {
                super.actionPerformed(event);
            } else {
                if ((VWStringUtils.compare(actionCMD, VWTaskActionCommand.START) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.STOP) == 0) && selectedNode.isDirty()) {
                    Object[] options = new String[]{VWResource.Apply, VWResource.Cancel};
                    int result = JOptionPane.showOptionDialog(this.m_mainFrame, VWResource.ApplyPropertyChanges, null, 1, 3, null, options, options[0]);
                    if (result == 0) {
                        boolean continueAction;
                        VWTaskPropertyPanel propPanel = selectedNode.getContentPane().getPropertyPanel();
                        if (propPanel != null && !(continueAction = propPanel.applyPropertiesOnAction(actionCMD))) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                Runnable actionPerformer = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        VWTaskCore.this.disableApplicationInput();
                        try {
                            selectedNode.actionPerformed(VWTaskCore.this.m_actionEvent);
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                        }
                        finally {
                            VWTaskCore.this.enableApplicationInput();
                            selectedNode.nodeChanged();
                        }
                    }
                };
                Thread actionThread = new Thread(actionPerformer, "VWTaskCore:actionPerformed");
                actionThread.start();
            }
        }
        catch (Exception ex) {
            if (selectedNode != null) {
                selectedNode.displayError(ex);
            }
            VWDebug.logException(ex);
        }
    }

    public void treeNodesChanged(TreeModelEvent event) {
        try {
            VWTaskBaseNode parent = (VWTaskBaseNode)event.getTreePath().getLastPathComponent();
            VWTaskBaseNode node = null;
            Object[] children = event.getChildren();
            if (children != null && children.length > 0) {
                node = (VWTaskBaseNode)children[0];
            } else if (parent != null) {
                node = parent;
            }
            this.updateApplicationFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void treeNodesRemoved(TreeModelEvent event) {
        try {
            VWTaskBaseNode parent = (VWTaskBaseNode)event.getTreePath().getLastPathComponent();
            this.updateApplicationFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void treeNodesInserted(TreeModelEvent event) {
        try {
            VWTaskBaseNode parent = (VWTaskBaseNode)event.getTreePath().getLastPathComponent();
            this.updateApplicationFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void treeStructureChanged(TreeModelEvent event) {
    }

    private VWTaskCore() {
        super(m_bAutoMode);
    }

    protected void init(JFrame mainFrame, VWTaskApplicationSettings appSettings, boolean automode) {
        if (this.m_initialized) {
            throw new RuntimeException("VWTaskCore already initialized.");
        }
        try {
            this.m_appSettings = appSettings;
            m_bAutoMode = automode;
            this.m_mainFrame = mainFrame;
            if (!automode) {
                VWSessionInfo sessionInfo = new VWSessionInfo(this.getMainFrame().getContentPane(), null);
                super.init(sessionInfo);
            }
            this.m_taskRoot = new VWTaskRootNode(this.m_appSettings);
            this.m_treeModel = new DefaultTreeModel(this.m_taskRoot);
            if (!automode) {
                RepaintManager repaintManager = RepaintManager.currentManager(this.m_mainFrame);
                if (!repaintManager.isDoubleBufferingEnabled()) {
                    repaintManager.setDoubleBufferingEnabled(true);
                }
                this.m_mainFrame.getContentPane().setLayout(new BorderLayout());
                this.initApplicationPanels();
                this.initApplicationOptions();
                this.m_taskRoot.refresh();
                this.m_menuBar = new VWTaskMenuBar(this.m_mainFrame, this.m_bViewMsgPane, this);
                this.m_mainFrame.getRootPane().setJMenuBar(this.m_menuBar);
                this.m_toolBar = new VWTaskToolBar();
                this.m_mainFrame.getContentPane().add((Component)this.m_toolBar, "First");
                this.rebuildMainPanel();
                if (this.m_mainFrame != null) {
                    this.m_mainFrame.invalidate();
                    this.m_mainFrame.validate();
                    this.m_mainFrame.repaint();
                }
                this.addVWConsoleListener(this.m_menuBar);
                this.m_toolBar.addActionListener(this);
                this.m_vwContentPane.addActionListener(this);
                this.m_vwContentPane.addVWTaskContentListener(this.m_vwScopePane);
                this.m_vwContentPane.addVWTaskContentListener(this.m_toolBar);
                this.m_vwContentPane.addVWTaskContentListener(this.m_menuBar);
                this.m_vwScopePane.addActionListener(this);
                this.m_vwScopePane.getTree().addTreeSelectionListener(this.m_vwContentPane);
                this.m_vwScopePane.getTree().getModel().addTreeModelListener(this.m_vwContentPane);
                this.m_treeModel.addTreeModelListener(this);
                this.expandNodes();
                this.m_initialized = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            this.displayError(ex);
        }
    }

    protected static void releaseStaticReferences() {
        m_instance = null;
    }

    protected void autoStartTasks() throws Exception {
        this.m_taskRoot.autoStartTasks();
    }

    protected void autoStopTasks() throws Exception {
        this.m_taskRoot.autoStopTasks();
    }

    public VWTaskRootNode getRootNode() {
        return this.m_taskRoot;
    }

    protected VWConsoleMsgPanel getConsoleMsgPanel() {
        return this.m_consoleMsgPanel;
    }

    public VWTaskBaseNode getSelectedNode() {
        return this.m_vwContentPane != null ? this.m_vwContentPane.getSelectedNode() : this.m_taskRoot;
    }

    public VWTaskContentPane getContentPane() {
        return this.m_vwContentPane;
    }

    protected DefaultTreeModel getTreeModel() {
        return this.m_treeModel;
    }

    public VWTaskMenuBar getMenuBar() {
        return this.m_menuBar;
    }

    private void initApplicationPanels() {
        try {
            this.m_consoleMsgPanel = new VWConsoleMsgPanel(this.m_mainFrame, this);
            this.m_vwContentPane = new VWTaskContentPane();
            this.m_vwContentPane.init(this.m_taskRoot, this.m_mainFrame, this.m_mainFrame);
            this.m_vwScopePane = new VWTaskScopePane();
            this.m_vwScopePane.init(this.m_treeModel, this.m_mainFrame, this.m_mainFrame);
            if (ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight()) {
                this.m_rootSplitPane = new VWSplitPane(1, this.m_vwScopePane, this.m_vwContentPane);
                this.m_rootSplitPane.setDividerLocation(0.25);
            } else {
                this.m_rootSplitPane = new VWSplitPane(1, this.m_vwContentPane, this.m_vwScopePane);
                this.m_rootSplitPane.setDividerLocation(0.75);
            }
            this.m_rootSplitPane.setDividerSize(4);
            this.m_rootSplitPane.setOneTouchExpandable(true);
            this.m_rootSplitPane.setResizeWeight(0.0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void expandNodes() {
        this.m_taskRoot.expandChildNodes();
        if (!this.m_taskRoot.setFocusToRequestingChildNode() && this.m_taskRoot.getChildCount() > 0) {
            VWTaskBaseNode node = (VWTaskBaseNode)this.m_taskRoot.getChildAt(0);
            if (node.getType() == 1 && node.getChildCount() > 0 && ((VWTaskBaseNode)node.getChildAt(0)).getType() != 1) {
                node = (VWTaskBaseNode)node.getChildAt(0);
            }
            this.setFocus(node);
        }
    }

    private void initApplicationOptions() {
        Element ele;
        block16: {
            VWTaskXMLHandler xmlHandler = this.m_appSettings.getXMLHandler();
            if (xmlHandler == null) {
                return;
            }
            ele = (Element)xmlHandler.getRootNode();
            if (ele == null) {
                return;
            }
            try {
                if (ele.getAttributeNode("ShowMessages") != null) {
                    this.m_bViewMsgPane = new Boolean(ele.getAttribute("ShowMessages"));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (ele.getAttributeNode("MessageLevel") == null) break block16;
                String strLevel = ele.getAttribute("MessageLevel");
                Level level = null;
                try {
                    switch (Integer.parseInt(strLevel)) {
                        case 1: {
                            level = Level.SEVERE;
                            break;
                        }
                        case 2: {
                            level = Level.WARNING;
                            break;
                        }
                        default: {
                            level = Level.INFO;
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    level = Level.parse(strLevel);
                }
                this.m_consoleMsgPanel.setMessageLevel(level);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        try {
            if (ele.getAttributeNode("MaxMessages") != null) {
                this.m_consoleMsgPanel.setMaxMessages(Integer.parseInt(ele.getAttribute("MaxMessages")));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void rebuildMainPanel() {
        if (this.m_mainPanel == null) {
            this.m_mainPanel = new JPanel();
            this.m_mainPanel.setLayout(new BorderLayout());
        } else {
            this.m_mainPanel.removeAll();
        }
        if (this.m_bViewMsgPane) {
            if (this.m_viewSplitPane == null) {
                this.m_viewSplitPane = new VWSplitPane(0, this.m_rootSplitPane, this.m_consoleMsgPanel);
                this.m_viewSplitPane.setToolTipText(VWResource.SlideToAdjustView);
                this.m_viewSplitPane.setOneTouchExpandable(true);
                this.m_viewSplitPane.setDividerSize(4);
                this.m_viewSplitPane.setResizeWeight(1.0);
                this.m_viewSplitPane.setDividerLocation(0.8);
            } else {
                this.m_viewSplitPane.setTopComponent(this.m_rootSplitPane);
                this.m_viewSplitPane.setBottomComponent(this.m_consoleMsgPanel);
            }
            this.m_mainPanel.add((Component)this.m_viewSplitPane, "Center");
        } else {
            this.m_mainPanel.add((Component)this.m_rootSplitPane, "Center");
        }
        this.getMainFrame().getContentPane().add((Component)this.m_mainPanel, "Center");
        if (this.m_mainFrame != null) {
            this.m_mainFrame.invalidate();
            this.m_mainFrame.validate();
            this.m_mainFrame.repaint();
        }
    }

    protected void viewConsoleMessagePane() {
        this.m_bViewMsgPane = !this.m_bViewMsgPane;
        this.rebuildMainPanel();
        this.fireConsoleVisibilityChangedEvent(new VWConsoleEvent((Object)this, this.m_bViewMsgPane));
        try {
            this.updateApplicationFile();
        }
        catch (Exception e) {
            VWDebug.logException(e, "Error updating application file.");
        }
    }

    protected void performExitItemAction(boolean bCloseWindow) {
        try {
            if (!bCloseWindow) {
                return;
            }
            if (this.m_mainFrame != null) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this.m_mainFrame, 201));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void disableApplicationInput() {
        if (this.m_appInputEnabled && !this.isAutoMode()) {
            VWTaskUtil.showWaitCursor(true, this.getMainFrame());
            this.m_appInputEnabled = false;
        }
    }

    public void enableApplicationInput() {
        if (!this.m_appInputEnabled && !this.isAutoMode()) {
            VWTaskUtil.showWaitCursor(false, this.getMainFrame());
            this.m_appInputEnabled = true;
        }
    }

    private void fireConsoleVisibilityChangedEvent(VWConsoleEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_consoleListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != VWConsoleListener.class) continue;
            ((VWConsoleListener)listeners[i + 1]).consoleVisibilityChanged(event);
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   13 Feb 2009 17:38:40  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.57  $";
    }
}

